#!/bin/bash

MODEL_PATH="/data2/huggingface/Qwen/Qwen2.5-VL-7B-Instruct"
DATASET="scannet"
TRAIN_DATA="./Projects/Chat-Scene/annotations/scannet/scannetv2_train.txt"
EVAL_DATA="./Projects/Chat-Scene/annotations/scannet/scannetv2_val.txt"
VIDEO_FOLDER="/data2/datasets/scannet/video"
MAX_PIX=3584
MIN_PIX=16
NUM_WORKERS=1
OUTPUT_DIR="/data2/datasets/scannet/preprocessed_data_maxpix_3584"

CUDA_VISIBLE_DEVICES=0 python preprocess_scannet.py \
  --model_name $MODEL_PATH \
  --dataset $DATASET \
  --train_data_path $TRAIN_DATA \
  --eval_data_path $EVAL_DATA \
  --video_folder $VIDEO_FOLDER \
  --max_pix_size $MAX_PIX \
  --min_pix_size $MIN_PIX \
  --num_workers $NUM_WORKERS \
  --output_dir $OUTPUT_DIR
